<?php

namespace Database\Seeders;

use App\Models\Languages;
use App\Models\Users;
use Illuminate\Database\Seeder;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $language = Languages::first();

        if ($language == null) {

            $user = Users::first();

            $languages = [
                ['id' => 'df8a9fe2-15af-11ee-83f2-d85ed3312c1f', 'order' => 1, 'code' => 'en', 'name' => 'English', 'imageUrl' => 'images/flags/united-states.svg', 'createdBy' => $user->id],
                ['id' => 'ef46fe64-15af-11ee-83f2-d85ed3312c1f', 'order' => 2, 'code' => 'cn', 'name' => 'Chinese', 'imageUrl' => 'images/flags/china.svg', 'createdBy' => $user->id],
                ['id' => 'f8041d27-15af-11ee-83f2-d85ed3312c1f', 'order' => 3, 'code' => 'es', 'name' => 'Spanish', 'imageUrl' => 'images/flags/france.svg', 'createdBy' => $user->id],
                ['id' => 'fe78a067-15af-11ee-83f2-d85ed3312c1f', 'order' => 4, 'code' => 'ar', 'name' => 'Arabic', 'imageUrl' => 'images/flags/saudi-arabia.svg', 'createdBy' => $user->id],
                ['id' => '04906ab8-15b0-11ee-83f2-d85ed3312c1f', 'order' => 5, 'code' => 'ru', 'name' => 'Russian', 'imageUrl' => 'images/flags/russia.svg', 'createdBy' => $user->id],
                ['id' => '10ac83d1-15b0-11ee-83f2-d85ed3312c1f', 'order' => 6, 'code' => 'ja', 'name' => 'Japanese', 'imageUrl' => 'images/flags/japan.svg', 'createdBy' => $user->id],
                ['id' => '1d9a6233-15b0-11ee-83f2-d85ed3312c1f', 'order' => 7, 'code' => 'fr', 'name' => 'French', 'imageUrl' => 'images/flags/france.svg', 'createdBy' => $user->id],
                ['id' => '9ed7278c-c7e7-4c91-9a83-83833603eb47', 'order' => 8, 'code' => 'ko', 'name' => 'Korean ', 'imageUrl' => 'images/flags/south-korea.svg', 'createdBy' => $user->id]
            ];
            Languages::insert($languages);
        }
    }
}
